<?Lassoscript

Define_Type: 'C_URL', -prototype;
	local: 'url' = '';	//string representation of the url
	local: '_cached' = false;
	local: '_protocol' = '';
	local: '_host' = '';
	local: '_path' = '';
	
	Define_Tag: 'onCreate', -optional='url';
		(local_defined: 'url') ? self->(setURL: #url);	//if specified, we initialize with the given url
	/Define_Tag;
	
	Define_Tag: 'getURL';
		return: self->'url';			//simply return the url string
	/Define_Tag;
	
	Define_Tag: 'setURL', -required='url';
		self->'url' = #url;				//set the url string
		self->'_cached' = false;		//indicate that it has not yet been parsed
	/Define_Tag;
	
	Define_Tag: 'getProtocol';
		self->parseURL;				//try to parse the url first
		return: self->'_protocol';		//then return the protocol
	/Define_Tag;
	
	Define_Tag: 'setProtocol', -required='value';
		self->'parseURL';			//make sure it is parsed
		self->'_protocol' = #value;	//update the protocol
		self->constructURL;			//assemble the url from the parts
	/Define_Tag;
	
	Define_Tag: 'getHost';
		self->parseURL;				//try to parse the url first
		return: self->'_host';		//then return the host
	/Define_Tag;
	
	Define_Tag: 'setHost', -required='value';
		self->'parseURL';			//make sure it is parsed
		self->'_host' = #value;	//update the host
		self->constructURL;			//assemble the url from the parts
	/Define_Tag;
	
	Define_Tag: 'getPath';
		self->parseURL;				//try to parse the url first
		return: self->'_path';		//then return the path
	/Define_Tag;
	
	Define_Tag: 'setPath', -required='value';
		self->'parseURL';			//make sure it is parsed
		self->'_path' = #value;	//update the path
		self->constructURL;			//assemble the url from the parts
	/Define_Tag;
	
	Define_Tag: 'constructURL';
		self->'url' = self->'_protocol';		//begin with the protocol
		if: self->'_protocol' != 'mailto:';		//handle this one differently
			self->'url' += '//';
		/if;
		self->'url' += self->'_host';
		self->'url' += self->'_path';
	/Define_Tag;
	
	Define_Tag: 'parseURL';
		if: !self->'_cached';
			self->'_cached' = false;
			self->'_protocol' = '';
			self->'_host' = '';
			self->'_path' = '';
			
			protect;
				self->'_protocol' = self->'url'->(split: '//')->(get: 1);				//extract the protocol part
				self->'_host' = self->'url'->(split: '//')->(get: 2);					//get the remaining part
				self->'_path' = self->'_host';											//temporarily, set _path=_host
				self->'_host' = self->'_host'->(split: '/')->(get: 1);					//split at the first occurrence of a /, get first part
				self->'_path' = self->'_path'->(substring: self->'_host'->length + 1);	//remove the host part
				self->'_cached' = true;
			/protect;
		/if;
	/Define_Tag;
/Define_Type;


Define_Type: 'C_String', 'String', -prototype;
	Define_Tag: 'onCreate', -optional='value';
		if: (local_defined: 'value');
			self = #value;
		/if;
	/Define_Tag;

	Define_Tag: 'onAssign';
//log_detail: self->type + '->(' + tag_name + ':' + (params - 'array: ') + ')';
		if: self->size > 0;
			self->(remove: 1);
		/if;
		self->(append: params->(get: 1));
		return: true;
	/Define_Tag;
	
	Define_Tag: '+=';
		self->parent += params->(get: 1);
		return: true;
	/Define_Tag;
	
	Define_Tag: '-=';
		self->parent -= params->(get: 1);
		//it was expected to return a value, but that errors
		//this is probably because of the order of calling that is invoked
		//due to the implementation of onAssign and onConvert
	/Define_Tag;

	Define_Tag: '*=';
		self->parent *= params->(get: 1);
		return: true;
	/Define_Tag;
	
	//the callback tags '/=' and '%=' are not supported by the parent type String
	//we have not found a logical operation to be extending the String type with this,
	//so we do not support it either

	Define_Tag: 'onConvert';
		return: self->parent;
	/Define_Tag;
	
	Define_Tag: 'left', -required='length';
		return: self->(substring: 1, #length);
	/Define_Tag;
	
	Define_Tag: 'right', -required='length';
		return: self->(substring: self->size - #length + 1);
	/Define_Tag;
	
	Define_Tag: 'countFields', -required='delimiter';
		return: self->(split: #delimiter)->size;
	/Define_Tag;

	Define_Tag: 'getField', -required='delimiter', -required='count';
		protect;
			return: self->(split: #delimiter)->(get: #count);
		/protect;
		return: null;	//explicitly stated to ensure the return of null in the event of a missing field
	/Define_Tag;
/Define_Type;



Define_Type: 'C_Integer', -prototype;
	local: 'format' = array;
	local: 'value' = integer;
	
	Define_Tag: 'onCreate', -optional='value';
		if: (local_defined: 'value');
			self->'value' = #value;
		/if;
	/Define_Tag;

	Define_Tag: 'onAssign';
			params->(get: 1)->type;
			self->'value' = (integer: params->(get: 1));
		return: true;
	/Define_Tag;
	
	Define_Tag: '+=';
		self->'value' += params->(get: 1);
		return: true;
	/Define_Tag;
	
	Define_Tag: '-=';
		self->'value' -= params->(get: 1);
		return: true;
		//it was expected to return a value, but that errors
		//this is probably because of the order of calling that is invoked
		//due to the implementation of onAssign and onConvert
	/Define_Tag;

	Define_Tag: '*=';
		self->'value' *= params->(get: 1);
		return: true;
	/Define_Tag;
	
	Define_Tag: '/=';
		self->'value' /= params->(get: 1);
		return: true;
	/Define_Tag;
	
	Define_Tag: 'onConvert';
		select: params->(get: 1);
		case: 'string';
			null->\setFormat->(run: -name='setFormat', -owner=self->'value', -params=self->'format');
			return: (string: self->'value');
		case: 'integer';
			return: (integer: self->'value');
		case: 'decimal';
			return: (decimal: self->'value');
		/select;
		
	/Define_Tag;
	
	Define_Tag: '_unknownTag';
		local: 'tag' = integer->properties->second->(find: tag_name);
		local: 'result' = null;
		if: #tag == null;
			#tag = null->properties->second->(find: tag_name);
		/if;
		
		if: #tag != null;
			#result = #tag->(run: -name=tag_name, -owner=self->'value', -params=params);
		else;
			fail: -9948, 'No tag, type or constant was defined under the name ' + self->type + '->' + tag_name + ' with arguments ' + params;
		/if;
	/Define_Tag;
	
	Define_Tag: 'setFormat';
		self->'format' = params;
	/Define_Tag;
/Define_Type;

?>